<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN908210NL02 - Reject Qualified Application Role Request</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="transmission-wrapper" id="PRPM_IN908120NL02-wrapper">
        <param name="element" value="hl7:PRPM_IN908120NL02"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN908120NL02-controlAct">
        <param name="element" value="hl7:PRPM_IN908120NL02/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN908120NL02/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN908120NL02/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN908120NL02/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- sender -->
        <rule context="hl7:PRPM_IN908120NL02/hl7:sender/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn</assert>
        </rule>
        <!-- receiver -->
        <rule context="hl7:PRPM_IN908120NL02/hl7:receiver/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>AcknowledgementType</title>
        <rule context="hl7:PRPM_IN908120NL02/hl7:acknowledgement">
            <assert role="error" test="@typeCode='AE' or @typeCode='AR'"
                >Het type antwoord van een afwijzing moet 'AE' or 'AR' zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/assignedEntity/relatedTo/assignedDevice/part/QualifiedApplicationRole</title>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:code">
            <extends rule="CE"/>
            <assert role="warning" test="@codeSystem='2.16.840.1.113883.2.4.3.11.3'"
                >QualifiedApplicationRole/code moet komen uit '2.16.840.1.113883.2.4.3.11.3'</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/QualifiedApplicationRole/partOf/assignedDevice</title>
        <rule context="hl7:subject/hl7:QualifiedApplicationRole/hl7:partOf/hl7:assignedDevice/hl7:id">
            <extends rule="II"/>
            <assert role="warning" test="@root='2.16.840.1.113883.2.4.6.6'"
                >assignedDevice/id/@root moet '2.16.840.1.113883.2.4.6.6' bevatten</assert>
        </rule>
    </pattern>
</schema>
